//  This script file is copyright 1999 Henter-Joyce, Inc.
//
//  All Rights Reserved
//
//  Henter-Joyce software is distributed and licensed "as is", all
//  warranties, either express or implied, are disclaimed as to the
//  software and its quality, performance, or fitness for any
//  particular purpose.  You, the consumer, bear the entire risk
//  relating to the quality of the software and if the software
//  proves to have any defects, you assume the cost of any necessary
//  servicing or repairs.

//  Description: Installation script for JAWS for Windows

// Install Scripts for JFW 3.31
// Original Author: J. David Boyd
// Maintained by Mike Pedersen and Ralph (Ernie) Ocampo
// Last Modified: 08/3/99 reo



@DefineProto
	//Get Drive Information
	@Void @GetDriveAndDirInfo( @Void )

	//Get Keyboard Type FULL/LAPTOP
	//Uses Options 200-201
	@Void @GetKeyboardType ( @Void )

	//The following was added to create @GetSynth/@GetBraille this replaces @GetFromFile
	@Void @MakeGetDevices (@In @QString @MyFilename, @In @QString @DeviceType, @In @QString @DeviceShortName, @In @Integer @StartValue)

	//Get Options List from a file (Used by GetSynth and GetBraille)
//	@QString @GetFromFile (@In @QString @DeviceType, @In @Integer @StartValue, @In @QString @MyFilename)

	//Get Synth Name for Primary and/or Secondary Synth
	//Uses Options 300-3xx (based on @MaxItems)
//GetSynth Created by @MakeGetDevices *** jmb, 6/21/97
//	@Void @GetSynth(@Out @QString @Picked, @Out @QString @ShortName, @Out @QString @FullName, @Out @QString @TypeDevice, @Out @QString @Port, @Out @QString @PortInfo, @Out @QString @Extra)
	@Void @GetPrimarySynth ( @Void )
	@Void @GetSecondarySynth ( @Void )
	@Void @GetTertiarySynth ( @Void )

	//Get Braille Device Name for Primary and/or Secondary Braille Device
	//Uses Options 400-4xx (based on @MaxItems)
//GetBraille Created by @MakeGetDevices *** jmb, 6/21/97
//	@Void @GetBraille(@Out @QString @Picked, @Out @QString @ShortName, @Out @QString @FullName, @Out @QString @TypeDevice, @Out @QString @Port, @Out @QString @PortInfo, @Out @QString @Extra)
	@Void @GetPrimaryBraille ( @Void )
	@Void @GetSecondaryBraille ( @Void )

	//Get Device information from picked device (ex. PrimarySynth)
	@Void @GetDeviceInfo ( @In @QString @MyFilename , @In @QString @MyDevice, @Out @QString @ShortName, @Out @QString @FullName, @Out @QString @TypeDevice, @Out @QString @Extra, @Out @QString @DriverName, @Out @QString @DefaultPortString)

	//Asks user if they want to install an extra Synth/Braille Device
	@Integer @GetAnother ( @In @QString @DeviceType )
	//uses options 150-153
	@Void @GetSerial( @Out @Qstring @WhichCOM, @Out @QString @ExtraCOMInfo )
	//uses options 157-158
	@Void @GetSerial78( @Out @Qstring @WhichCOM, @Out @QString @ExtraCOMInfo )
	//uses options 175-178
	@Void @GetParallel( @Out @Qstring @WhichLPT, @Out @QString @ExtraLPTInfo )
	//uses options 157-158 and options 175-178
    @Void @GetSerialParallel( @Out @Qstring @WhichCOM, @Out @QString @ExtraCOMInfo)

	@Integer @AddToStartup( @Void )

@EndProto

@DefineFunc @Void @MakeGetDevices (@In @QString @MyFilename, @In @QString @DeviceType, @In @QString @DeviceShortName, @In @Integer @StartValue)
// ItemDefaultPortString=""
// ItemDefaultPortString=""

/*
@Display
@Cls
Inside of @@MakeGetDevices

@@MyFilename      =  @MyFilename
@@DeviceType      =  @DeviceType
@@DeviceShortName =  @DeviceShortName
@@StartValue      =  @StartValue
@@TTempDir        =  @TTempDir

@Pause
@EndDisplay
*/

@If (@Exists("@StartupDrive:\\@StartupDir\\@MyFilename"))
   @Counter = 1
   @Found = @False
   @NumItems = @StrToInt(@GetINI("list", "NumItems", "@StartupDrive:\\@StartupDir\\@MyFilename"))

@If (@NumItems>0)  //If No Items, Skip to End

	@write("@TTempDir@Slash@Slash@DeviceShortName.inc","wt","@@DefineProto\n")
	@write(,,"@@Void @@Get@DeviceShortName( @@Out @@QString @@Picked, ")
	@write(,,"@@Out @@QString @@ShortName, @@Out @@QString @@FullName, ")
	@write(,,"@@Out @@QString @@TypeDevice, @@Out @@QString @@Port, ")
	@write(,,"@@Out @@QString @@PortInfo, @@Out @@QString @@Extra, ")
	@write(,,"@@Out @@QString @@DriverName, ")
	@write(,,"@@Out @@QString @@DefaultPortString)\n")
	@write(,,"@@EndProto\n\n")
	@write(,,"@@DefineFunc ")
	@write(,,"@@Void @@Get@DeviceShortName( @@Out @@QString @@Picked, ")
	@write(,,"@@Out @@QString @@ShortName, @@Out @@QString @@FullName, ")
	@write(,,"@@Out @@QString @@TypeDevice, @@Out @@QString @@Port, ")
	@write(,,"@@Out @@QString @@PortInfo, @@Out @@QString @@Extra, ")
	@write(,,"@@Out @@QString @@DriverName, ")
	@write(,,"@@Out @@QString @@DefaultPortString)\n")
	@write(,,"@@Counter=1\n")
    @write(,,"  @@NumSynths = 0\n")

    @TTTempDir = @MakeCompatiblePath("@TTempDir")
    @If( @StrCmpNos("@DeviceShortName", "synth") == 0 )
        @write(,,"  @@write(\"@TTTempDir\\\\@DeviceShortName.inx\", \"wt\", \"[Synth]\\n\")\n")
    @Else
        @write(,,"  @@write(\"@TTTempDir\\\\@DeviceShortName.inx\", \"wt\", \"[Braille]\\n\")\n")
    @Endif

	@write(,,"Initialize:\n")
	@write(,,"  @@ClearOption(@@Eval(@StartValue+@@Counter))\n")
	@write(,,"  @@If((@@Counter<=@NumItems))\n")
	@write(,,"    @@Counter = @@Eval(@@Counter+1)\n")
	@write(,,"    @@Goto Initialize\n")
	@write(,,"  @@EndIf\n\n")
	@write(,,"  @@Found = @@False\n\n")
    @write(,,"  @@DlgCtrlSize(0, 6, 1, 12, 48)\n")
	@write(,,"  @@GetOption\n")
	@write(,,"  @@Cls\n")
	@write(,,"  Please select a @DeviceType to add, or select\n")
	@write(,,"  \"No More\" to continue with the install. The first\n")
	@write(,,"  @Devicetype you choose will become the\n")
	@write(,,"  default @Devicetype.\n")
StartLoop:
	@If ((@Counter <= @NumItems))
		@write(,,"@@Option @Eval(@StartValue+@Counter)=\"")
		@write(,,"@GetINI("list","Item@Counter","@StartupDrive:\\@StartupDir\\@MyFilename")\"\n")
		@Counter = @Eval(@Counter + 1)
		@Goto StartLoop
	@Endif
EndLoop:
	@write(,,"  @@EndOption\n\n")
	@write(,,"@@Counter=1\n")
	@write(,,"LoopStart:\n")
	@write(,,"  @@If(@@OptionIsSet(@@Eval(@StartValue+@@Counter)))\n")
	@write(,,"    @@Found=@@True\n")
	@write(,,"  @@Endif\n")
	@write(,,"  @@If( (@@Counter>=@NumItems) || (@@Found==@@True) )\n")
	@write(,,"    @@Goto LoopEnd\n")
	@write(,,"  @@Endif\n")
	@write(,,"  @@Counter=@@Eval(@@Counter+1)\n")
	@write(,,"  @@Goto LoopStart\n")
	@write(,,"LoopEnd:\n\n")
	@write(,,"  @@Picked=@@GetINI(\"list\",\"Item@@Counter\",\"@@StartupDrive:\\\\@@StartupDir\\\\@MyFilename\")\n")
	@write(,,"  @@GetDeviceInfo(\"@MyFileName\",@@Picked,@@ShortName,@@FullName,@@TypeDevice,@@Extra, @@DriverName, @@DefaultPortString)\n")

  @write(,," @@DlgCtrlSize (0,-1,-1,0,0)\n")

    @write(,,"  @@If (@@IsEqual(@@ShortName,\"continue\"))\n")
    @write(,,"        @@Goto Continue\n")
    @write(,,"  @@Endif\n")

	@write(,,"  @@If (@@IsEqual(@@TypeDevice,\"Internal\"))\n")
	@write(,,"	@Slash@Slash Do nothing for Internal devices\n")

	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"Driver\"))\n")
	@write(,,"  @@Port = \"\"\n")
	@write(,,"  @@PortInfo = \"\"\n")
	@write(,,"	@Slash@Slash Do nothing for Driver devices\n")

	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"SSIL\"))\n")
	@write(,,"	@Slash@Slash Do nothing for SSIL devices\n")

	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"NONE\"))\n")
	@write(,,"	@Slash@Slash Do nothing for NONE\n")



	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"Serial\"))\n")
	@write(,,"	@@GetSerial(@@Port,@@PortInfo)\n")

	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"Parallel\"))\n")
	@write(,,"	@@GetParallel(@@Port,@@PortInfo)\n")

	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"Serial78\"))\n")
	@write(,,"	@@GetSerial78(@@Port,@@PortInfo)\n")

	@write(,,"  @@ElseIf (@@IsEqual(@@TypeDevice,\"SerialParallel\"))\n")
	@write(,,"	@@GetSerialParallel(@@Port,@@PortInfo)\n")

	@write(,,"  @@Else @@Display ERROR, Unknown device type in Get@DeviceShortName @Pause @EndDisplay\n")

	@write(,,"  @Endif\n")



    @TTTempDir = @MakeCompatiblePath("@TTempDir")
    @If( @StrCmpNos("@DeviceShortName", "synth") == 0 )

    @write(,,"  @@SynthFileCounter = ( @@SynthFileCounter + 1) \n")


    //    @write(,,"@@Display\n")
    //    @write(,,"@@Cls\n")
    //    @write(,,"SynthFileCounter = @@SynthFileCounter\n")
    //    @write(,,"@@Pause\n")
    //    @write(,,"@@EndDisplay\n")


    @write(,,"  @@write(\"@TTTempDir\\\\@DeviceShortName.inx\", \"at\", \"ItemName@@SynthFileCounter = @@ShortName\\n\")\n")
    @write(,,"  @@write(,,\"ItemLongName@@SynthFileCounter = @@FullName\\n\" ) \n")
    @write(,,"  @@write(,,\"ItemDriver@@SynthFileCounter = @@DriverName\\n\" ) \n")
    @write(,,"  @@write(,,\"ItemPort@@SynthFileCounter = @@Port@!@@PortInfo\\n\" ) \n")
    @Else

    @write(,,"  @@BrailleFileCounter = ( @@BrailleFileCounter + 1) \n")


    //    @write(,,"@@Display\n")
    //    @write(,,"@@Cls\n")
    //    @write(,,"BrailleFileCounter = @@BrailleFileCounter\n")
    //    @write(,,"@@Pause\n")
    //    @write(,,"@@EndDisplay\n")


    @write(,,"  @@write(\"@TTTempDir\\\\@DeviceShortName.inx\", \"at\", \"ItemName@@BrailleFileCounter = @@ShortName\\n\")\n")
    @write(,,"  @@write(,,\"ItemLongName@@BrailleFileCounter = @@FullName\\n\" ) \n")
    @write(,,"  @@write(,,\"ItemDriver@@BrailleFileCounter = @@DriverName\\n\" ) \n")
    @write(,,"  @@write(,,\"ItemPort@@BrailleFileCounter = @@Port@!@@PortInfo\\n\" ) \n")
    @EndIf

/*
@Display
@Cls
    @@Counter : @Counter
@Pause
@EndDisplay
*/

	@write("@TTempDir@Slash@Slash@DeviceShortName.inc","at","@@Counter=1\n")
    @write(,,"@@NumSynths = (@@NumSynths + 1)\n")
    @write(,,"@@Goto Initialize\n")


//    @COunter = 1
    //@Goto StartLoop


	@write("@TTempDir@Slash@Slash@DeviceShortName.inc","at","Continue:\n")


/*
@Display
@Cls
About to leave MakeGetDevices
@Pause
@EndDisplay
*/


	@write(,,"@@return()\n")
	@write(,,"@@EndFunc\n")
@Else
	@Goto NoItems
@EndIf
@Else
	@Goto FileNotFound
@Endif

@return()

NoItems:
	@Display
	ERROR, No Items in @@MyFilename
	@Pause
	@EndDisplay
	@return()
FileNotFound:
	@Display
	ERROR, @StartupDrive:\\@StartupDir\\@MyFilename not found!
	@Pause
	@EndDisplay
	@return()
@EndFunc

@DefineFunc @Void @GetDeviceInfo ( @In @QString @MyFilename , @In @QString @MyDevice, @Out @QString @ShortName, @Out @QString @FullName, @Out @QString @DeviceType, @Out @QString @Extra, @Out @QString @DriverName, @Out @Qstring @DefaultPortString)
//Use @! to end "@token"
  @ShortName = @GetINI("@MyDevice","ItemShort","@StartupDrive:\\@StartupDir\\@MyFilename")
  @FullName = @GetINI("@MyDevice","ItemLong","@StartupDrive:\\@StartupDir\\@MyFilename")
  @DeviceType = @GetINI("@MyDevice","ItemType","@StartupDrive:\\@StartupDir\\@MyFilename")
  @Extra = @GetINI("@MyDevice","ItemExtra","@StartupDrive:\@StartupDir\\@MyFilename")
  @DriverName = @GetINI("@MyDevice","ItemDriver","@StartupDrive:\\@StartupDir\\@MyFilename")
  @DefaultPortString = @GetINI("@MyDevice","ItemDefaultPortString","@StartupDrive:\\@StartupDir\\@MyFilename")

//  @write(,," @@DlgCtrlSize (0,-1,-1,0,0)\n")

// OnDisk reserved for future use
//@OnDisk = @GetINI(@MyDevice,@OnDisk,@StartupDrive:\\@StartupDir\\@MyFilename)
@return()
@EndFunc

@DefineFunc @Void @GetDriveAndDirInfo( @Void )

Again4:

  @ClearOption(510)
  @ClearOption(511)
  @ClearOption(512)
//Prime the Windows Drive and Dir info w/System Info
  @WinHomeDrive = @WinDrive
  @WinHomeDir = "@WinDir"
//original install script uses multiple supress statements, which isn't necessary, and since removable drives are suppressed, you don't have to test for them in the script
@DlgCtrlSize(0, 3, 3, 8, 20)
@GetOutDrive @JFWDrive
	@Suppress(0,17)  //don't include 1 - removable drives or 16 - CD-ROM drives
     @Cls
     On which disk drive do you wish to install @Name?
@EndOutDrive
@OutDrive = @JFWDrive
@DlgCtrlSize(0, -1, -1, 0, 0)



@If ( @DiskFree(@OutDrive) < 50000000 )
@DlgCtrlSize(0, 8, 3, 11, 40)
    @GetOption
    @Cls
    You may not have enough free disk space to install this
    software on the selected drive. You may select another
    drive to install on, or attempt to install to this drive.
    If errors occur, please abort the install, and clean up
    enough space so that at least 50M of disk space will be
    available.  Then rerun this install program.
    @Option 510 = "Reselect a drive"
    @Option 511 = "Continue the install"
    @EndOption
@DlgCtrlSize(0, -1, -1, 0, 0)
@Endif



@If(@OptionIsSet(510))
    @Goto Again4
@Endif


Again5:


@DlgCtrlSize(0, 10, 3, 11, 40)
@GetSubdir @JFWDir
     @Prompt = "Which Directory?"
     @Cls
     Now, please specify the destination directory where the
     @Name system will be installed.  Please use only eight
     characters or less per subdirectory, and no punctuation
     symbols or spaces.
     Press the Enter key to name the directory @JFWDir, or edit
     the directory below using the arrow, delete, letter and
     number keys.

@EndSubDir


@If( @IsEqual("@JFWDir", "\\"))
  @JFWDir="\\JFW331"
@Endif

@If( @IsEqual("@JFWDir", "\\ "))
  @JFWDir="\\JFW331"
@Endif


@If ( @IsSimpleDir("@JFWDir") == @False )
    @Display
    @Cls
    You have entered spaces or dots in the directory
    name, or some directory names in the entered path
    are longer than eight characters. Please re-enter
    the path leaving out any spaces or dots, and be
    certain that no individual sub-directory is longer
    than eight characters.
    @Pause
    @EndDisplay
    @JfwDir="\\JFW331"
    @Goto Again5
@Endif




@SubDir = @JFWDir
@JFWTempDir = "@JFWDir\\INSTTMP"



@DlgCtrlSize(0, -1, -1, 0, 0)
@return()
@EndFunc

@DefineFunc @Void @GetKeyboardType ( @Void )
//Clear Options 200-201
  @ClearOption (200)
  @ClearOption (201)
//Get Which Type of Keyboard


  @DlgCtrlSize(0, 3, 3, 6, 18)
  @GetOption
    @Cls
    Which type of Keyboard are you using?
    @Option 200 = "Full Sized"
    @Option 201 = "Laptop"
  @EndOption
  @DlgCtrlSize(0, -1, -1, 0, 0)


//Set @InstallType
  @If (@OptionIsSet(200))
	@KeyboardType = "DESKTOP"
  @ElseIf (@OptionIsSet(201))
	@KeyboardType = "LAPTOP"
  @Else
        @KeyboardType = "ERROR"
  @EndIf
@return()
@EndFunc

@DefineFunc @Void @GetPrimarySynth ( @Void )
  @GetSynth(@PrimarySynth, @PrimarySynthShort, @PrimarySynthFull, @PrimarySynthType, @PrimarySynthPort, @PrimarySynthPortInfo, @PrimarySynthExtra, @PrimarySynthDriver, @PrimarySynthDefaultPortString)
  @return()
@EndFunc

@DefineFunc @Void @GetSecondarySynth ( @Void )
  @GetSynth(@SecondarySynth, @SecondarySynthShort, @SecondarySynthFull, @SecondarySynthType, @SecondarySynthPort, @SecondarySynthPortInfo, @SecondarySynthExtra, @SecondarySynthDriver, @SecondarySynthDefaultPortString)
  @return()
@EndFunc

@DefineFunc @Void @GetTertiarySynth ( @Void )
  @GetSynth(@TertiarySynth, @TertiarySynthShort, @TertiarySynthFull, @TertiarySynthType, @TertiarySynthPort, @TertiarySynthPortInfo, @TertiarySynthExtra, @TertiarySynthDriver, @TertiarySynthDefaultPortString)
  @return()
@EndFunc

@DefineFunc @Void @GetPrimaryBraille ( @Void )
  @GetBraille(@PrimaryBraille, @PrimaryBrailleShort, @PrimaryBrailleFull, @PrimaryBrailleType, @PrimaryBraillePort, @PrimaryBraillePortInfo, @PrimaryBrailleExtra, @PrimaryBrailleDriver, @PrimaryBraillePortString)
  @return()
@EndFunc

@DefineFunc @Void @GetSecondaryBraille ( @Void )
  @GetBraille(@SecondaryBraille, @SecondaryBrailleShort, @SecondaryBrailleFull, @SecondaryBrailleType, @SecondaryBraillePort, @SecondaryBraillePortInfo, @SecondaryBrailleExtra, @SecondaryBrailleDriver, @SecondaryBraillePortString)
  @return()
@EndFunc

@DefineFunc @Integer @GetAnother ( @In @QString @DeviceType )
  @return(@GetYesNo("Install another @DeviceType?"))
@EndFunc

@DefineFunc @Void @GetSerial( @Out @Qstring @WhichCOM, @Out @QString @ExtraCOMInfo)
//uses options 150-153
  @ClearOption(150)
  @ClearOption(151)
  @ClearOption(152)
  @ClearOption(153)
  @GetOption
  @Cls
  Which COM port would you like to use?
    @Option 150 = "COM1"
    @Option 151 = "COM2"
    @Option 152 = "COM3"
    @Option 153 = "COM4"
  @EndOption
@If (@OptionIsSet(150))
    @WhichCOM = "com1:"
@ElseIf (@OptionIsSet(151))
    @WhichCOM = "com2:"
@ElseIf (@OptionIsSet(152))
    @WhichCOM = "com3:"
@Else
    @WhichCOM = "com4:"
@EndIf
@ExtraCOMInfo = @DefaultPortString
@return()
@EndFunc

@DefineFunc @Void @GetSerial78( @Out @Qstring @WhichCOM, @Out @QString @ExtraCOMInfo)
//uses options 157-158
  @GetSerial( @WhichCOM, @ExtraCOMInfo)
  @ClearOption(157)
  @ClearOption(158)
  @GetOption
  @Cls
  Which Communications Settings does this device use?
    @Option 157 = "9600,n,8,1,x"
    @Option 158 = "9600,n,7,1,x"
  @EndOption
@If (@OptionIsSet(157))
    @ExtraCOMInfo = "9600,n,8,1,x"
@Else
    @ExtraCOMInfo = "9600,n,7,1,x"
@EndIf
@return()
@EndFunc


@DefineFunc @Void @GetParallel( @Out @Qstring @WhichLPT, @Out @QString @ExtraLPTInfo )
  @ClearOption(175)
  @ClearOption(176)
  @ClearOption(177)
  @ClearOption(178)
  @GetOption
    @Cls
  Which LPT port would you like to use?
    @Option 175 = "LPT1"
    @Option 176 = "LPT2"
    @Option 177 = "LPT3"
    @Option 178 = "LPT4"
  @EndOption
@If (@OptionIsSet(175))
    @WhichLPT = "LPT1"
@ElseIf (@OptionIsSet(176))
    @WhichLPT = "LPT2"
@ElseIf (@OptionIsSet(177))
    @WhichLPT = "LPT3"
@Else
    @WhichLPT = "LPT4"
@EndIf
@ExtraLPTInfo = ""
@return()
@EndFunc



@DefineFunc @Void @GetSerialParallel( @Out @Qstring @WhichCOM, @Out @QString @ExtraCOMInfo)
//uses options 150-153
  @ClearOption(150)
  @ClearOption(151)
  @ClearOption(152)
  @ClearOption(153)
  @ClearOption(175)
  @ClearOption(176)
  @ClearOption(177)
  @ClearOption(178)
  @GetOption
  @Cls
  Which COM or LPT port would you like to use?
    @Option 150 = "COM1"
    @Option 151 = "COM2"
    @Option 152 = "COM3"
    @Option 153 = "COM4"
    @Option 175 = "LPT1"
    @Option 176 = "LPT2"
    @Option 177 = "LPT3"
    @Option 178 = "LPT4"
  @EndOption
@If (@OptionIsSet(150))
    @WhichCOM = "com1:"
    @ExtraCOMInfo = @DefaultPortString
@ElseIf (@OptionIsSet(151))
    @WhichCOM = "com2:"
    @ExtraCOMInfo = @DefaultPortString
@ElseIf (@OptionIsSet(152))
    @WhichCOM = "com3:"
    @ExtraCOMInfo = @DefaultPortString
@ElseIf (@OptionIsSet(153))
    @WhichCOM = "com4:"
    @ExtraCOMInfo = @DefaultPortString
@ElseIf (@OptionIsSet(175))
    @WhichCOM = "LPT1"
    @ExtraCOMInfo = ""
@ElseIf (@OptionIsSet(176))
    @WhichCOM = "LPT2"
    @ExtraCOMInfo = ""
@ElseIf (@OptionIsSet(177))
    @WhichCOM = "LPT3"
    @ExtraCOMInfo = ""
@Else
    @WhichCOM = "LPT4"
    @ExtraCOMInfo = ""
@EndIf
@return()
@EndFunc












@DefineFunc @Integer @AddToStartup( @Void )
/* Put JFW in the startup group? */
//uses options 501-502
@If (@WinMajor >= 4)
  @If(@Platform == 3)
    @ClearOption(501)
    @ClearOption(502)
    @DlgCtrlSize(0, 15, 3, 19, 31)
    @GetOption
      @If (@Exists("@OutDrive:\\OPENBOOK\\OPENBOOK.EXE"))
      @Cls
      The Install program can set up
      JAWS for Windows to start
      automatically every time Windows
      is started.

      Since OPENBOOK exists on your system,
      it is recommended that you do NOT
      setup JAWS to start automatically,
      as it will interfere with
      An Open Book Unbound
      @Else
      @Cls
      The Install program can set up
      JAWS for Windows to start
      automatically every time
      Windows is started.
      @Endif

      @Option 501 = "Add JFW to your Startup"
      @Option 502 = "Do not load automatically"
    @EndOption
    @DlgCtrlSize(0, -1, -1, 0, 0)
  @EndIf
@EndIf
@Return(@OptionIsSet(501))
@EndFunc
